/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.item.perk.PerkItem;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import dev.toma.gunsrpg.common.perk.PerkType;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import dev.toma.gunsrpg.resource.perks.PurificationConfiguration;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CrystalPurificationStationTileEntity
extends InventoryTileEntity {
    public static final int OUT = 0;
    public static final int IN = 1;
    public static final int[] ORB = new int[]{2, 3, 4};

    protected CrystalPurificationStationTileEntity(TileEntityType<? extends CrystalPurificationStationTileEntity> type) {
        super(type);
    }

    public CrystalPurificationStationTileEntity() {
        this((TileEntityType<? extends CrystalPurificationStationTileEntity>)((TileEntityType)ModBlockEntities.CRYSTAL_PURIFICATION.get()));
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(5);
    }

    public void purify(PlayerEntity player) {
        IPlayerData data = PlayerData.getUnsafe(player);
        IPerkProvider provider = data.getPerkProvider();
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        PurificationConfiguration puficationConfig = perkConfig.getPurificationConfig();
        int orbCount = this.getOrbCount();
        PurificationConfiguration.Entry entry = puficationConfig.getValueForAmount(orbCount);
        int price = entry.getPrice();
        provider.awardPoints(-price);
        Random random = player.func_70681_au();
        float breakChance = entry.getBreakChance();
        if (random.nextFloat() < breakChance) {
            this.clearInputs();
            return;
        }
        ItemStack input = this.itemHandler.getStackInSlot(1);
        Crystal crystal = CrystalItem.getCrystal(input);
        EnumMap<PerkType, List<CrystalAttribute>> attributeMap = crystal.groupByType();
        float debuffChance = entry.getSuccessChance();
        PerkType type = random.nextFloat() < debuffChance ? PerkType.DEBUFF : PerkType.BUFF;
        List list = (List)attributeMap.get((Object)type);
        if (!list.isEmpty()) {
            int randomAttributeIndex = random.nextInt(list.size());
            list.remove(randomAttributeIndex);
        }
        Crystal newCrystal = Crystal.mergeAttributes(crystal.getLevel(), attributeMap);
        ItemStack result = new ItemStack((IItemProvider)input.func_77973_b());
        CrystalItem.addCrystal(result, newCrystal);
        this.clearInputs();
        this.itemHandler.setStackInSlot(0, result);
    }

    public boolean canPurify(IPerkProvider provider) {
        int orbs = this.getOrbCount();
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        PurificationConfiguration config = perkConfig.getPurificationConfig();
        PurificationConfiguration.Entry entry = config.getValueForAmount(orbs);
        if (entry == null) {
            return false;
        }
        int price = entry.getPrice();
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        Crystal crystal = CrystalItem.getCrystal(this.itemHandler.getStackInSlot(1));
        if (crystal == null || !crystal.hasAnyAttributes()) {
            return false;
        }
        return price <= provider.getPoints();
    }

    public int getPrice() {
        return this.getPrice(this.getOrbCount());
    }

    public int getPrice(int orbCount) {
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        PurificationConfiguration puficationConfig = perkConfig.getPurificationConfig();
        PurificationConfiguration.Entry entry = puficationConfig.getValueForAmount(orbCount);
        return this.itemHandler.getStackInSlot(1).func_190926_b() || entry == null ? -1 : entry.getPrice();
    }

    public int getOrbCount() {
        return (int)Arrays.stream(ORB).mapToObj(value -> this.itemHandler.getStackInSlot(value)).filter(stack -> !stack.func_190926_b()).count();
    }

    public PerkVariant getTargetedPerkVariant() {
        PerkVariant input = this.getItemVariant(this.itemHandler.getStackInSlot(1));
        if (input != null) {
            return input;
        }
        for (int slot : ORB) {
            PerkVariant variant = this.getItemVariant(this.itemHandler.getStackInSlot(slot));
            if (variant == null) continue;
            return variant;
        }
        return null;
    }

    public PerkVariant getItemVariant(ItemStack stack) {
        return stack.func_190926_b() ? null : ((PerkItem)stack.func_77973_b()).getVariant();
    }

    private void clearInputs() {
        this.itemHandler.setStackInSlot(1, ItemStack.field_190927_a);
        for (int slot : ORB) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
        }
    }
}

